package ru.yandex.calendar.logic.sending;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.contact.UnivContact;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.ics.exp.EventInstanceParameters;
import ru.yandex.calendar.logic.sending.param.CommonEventMessageParameters;
import ru.yandex.calendar.logic.sending.param.EventMessageInfo;
import ru.yandex.calendar.logic.sending.param.EventMessageInfoCreator;
import ru.yandex.calendar.logic.sending.param.MessageOverrides;
import ru.yandex.calendar.logic.sending.param.NotificationMessageParameters;
import ru.yandex.calendar.logic.sending.param.Recipient;
import ru.yandex.calendar.logic.sending.param.Sender;
import ru.yandex.calendar.logic.svc.SvcRoutines;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.resources.UStringLiteral;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.misc.email.Email;

/**
 * @author akirakozov
 * @author Stepan Koltsov
 */
public final class EventNotificationMessageXmlCreator {

    @Autowired
    private SvcRoutines svcRoutines;
    @Autowired
    private EventMessageInfoCreator eventMessageInfoCreator;
    @Autowired
    private SettingsRoutines settingsRoutines;


    public NotificationMessageParameters createNotificationMessageParameters(
            PassportUid uid, UnivContact recipient,
            EventWithRelations event, RepetitionInstanceInfo repetition,
            Instant eventInstanceStart, Instant now, DateTimeZone tz)
    {
        Email senderEmail = svcRoutines.getCalendarInfoEmail(PassportAuthDomain.byUid(event.getEvent().getCreatorUid()));
        NameI18n senderName = new NameI18n(UStringLiteral.YA_CALENDAR, UStringLiteral.YA_CALENDAR_EN);
        Sender sender = new Sender(Option.empty(), Option.empty(), senderName, Option.empty(), senderEmail);

        Language language = settingsRoutines.getLanguage(uid);

        Period period = EventRoutines.getPeriod(event.getEvent(), event.getTimezone());
        Instant instanceEnd = AuxDateTime.addPeriod(eventInstanceStart, period, event.getTimezone());

        EventInstanceParameters instance = new EventInstanceParameters(
                eventInstanceStart, instanceEnd, event.getRecurrenceId()
                        .orElse(() -> Option.when(repetition.getRepetition().isPresent(), eventInstanceStart)));

        EventMessageInfo emi = eventMessageInfoCreator.create(
                event, repetition, instance, recipient.getEmail(), Option.of(uid), language, tz);

        // XXX: --restore-- remove? // ssytnik@
        // Add hint info (if exists); uid - not null!
        //hintRoutines.getForUserAndAddTo(tz, recipientUid.get(), false, res, false); // always show

        String calendarUrl = svcRoutines.getCalendarUrlForUid(uid);

        CommonEventMessageParameters commonMessageParameters = new CommonEventMessageParameters(
                settingsRoutines.getLanguageOrGetDefault(recipient.getUid()),
                new LocalDateTime(now, tz), sender, Recipient.of(recipient, Option.empty()), senderEmail,
                calendarUrl, false, MessageOverrides.EMPTY);

        return new NotificationMessageParameters(
                commonMessageParameters, emi);
    }

} //~
