package ru.yandex.calendar.logic.sending;

import org.jdom.Element;

import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.util.base.AuxBase;
import ru.yandex.calendar.util.xml.TagReplacement;
import ru.yandex.calendar.util.xml.TagReplacement.Action;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 * @author Stepan Koltsov
 */
public final class EventXmlCreator {
    protected static final String DEF_MAIN_TAG_NAME = "message";

    public static void prepareAndAddIfNeeded(Element eMsg, String baseName, String value) {
        if (StringUtils.isEmpty(value)) { return; }
        String qValue = AuxBase.toSingleQuotedStringExceptQuot(value);
        eMsg.addContent(TagReplacement.processText(baseName + "-text", qValue, Action.TEXT_STRIP, EventRoutines.TAGS));
        eMsg.addContent(TagReplacement.processText(baseName + "-xml", qValue, Action.CONVERT_XML, EventRoutines.TAGS));
    }

} //~
