package ru.yandex.calendar.logic.sending;

import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.ChangedEventInfoForMails;
import ru.yandex.calendar.logic.ics.exp.EventInstanceParameters;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.sending.param.EventInviteeNames;
import ru.yandex.calendar.logic.sending.param.MessageDestination;
import ru.yandex.calendar.logic.sending.param.Recipient;
import ru.yandex.calendar.logic.sending.param.Sender;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 * XXX: copy-paste from EventSendingInfo // gutman@
 */
public class InvitationOrCancelEmailData {
    private final Sender sender;
    private final Recipient recipient;
    private final DateTimeZone tz;
    private final Option<String> privateTokenO;
    private final Option<IcsCalendar> ics;

    private final EventInviteeNames guestsNames;
    private final Option<ChangedEventInfoForMails> changesInfo;

    private final Decision decision;
    private final MailType meetingMailType;

    private final EventInstanceParameters eventInstance;
    private final Option<Long> reorganizedEventId;
    private final Option<ResourceInfo> subscriptionResource;

    private final MessageDestination destination;

    public InvitationOrCancelEmailData(
            Sender sender, Recipient recipient,
            DateTimeZone tz, Option<String> privateTokenO, Option<IcsCalendar> ics,
            EventInviteeNames guestsNames,
            Option<ChangedEventInfoForMails> changesInfo,
            Decision decision, MailType meetingMailType,
            EventInstanceParameters eventInstance,
            Option<Long> reorganizedEventId, Option<ResourceInfo> subscriptionResource, MessageDestination destination)
    {
        this.sender = sender;
        this.recipient = recipient;
        this.tz = tz;
        this.privateTokenO = privateTokenO;
        this.ics = ics;
        this.guestsNames = guestsNames;
        this.changesInfo = changesInfo;
        this.decision = decision;
        this.meetingMailType = meetingMailType;
        this.eventInstance = eventInstance;
        this.reorganizedEventId = reorganizedEventId;
        this.subscriptionResource = subscriptionResource;
        this.destination = destination;
    }

    public Sender getSender() {
        return sender;
    }

    public Recipient getRecipient() {
        return recipient;
    }

    public Option<PassportUid> getRecipientUid() {
        return recipient.getUid();
    }

    public DateTimeZone getTz() {
        return tz;
    }

    public Option<String> getPrivateTokenO() {
        return privateTokenO;
    }

    public Option<IcsCalendar> getIcs() {
        return ics;
    }

    public EventInviteeNames getGuestsNames() {
        return guestsNames;
    }

    public Option<ChangedEventInfoForMails> getChangesInfo() {
        return changesInfo;
    }

    public Decision getDecision() {
        return decision;
    }

    public MailType getMeetingMailType() {
        return meetingMailType;
    }

    public EventInstanceParameters getEventInstance() {
        return eventInstance;
    }

    public Option<Long> getReorganizedEventId() {
        return reorganizedEventId;
    }

    public Option<ResourceInfo> getSubscriptionResource() {
        return subscriptionResource;
    }

    public MessageDestination getDestination() {
        return destination;
    }
} //~
