package ru.yandex.calendar.logic.sending;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;
import ru.yandex.calendar.logic.sending.param.LayerInvitationMessageParameters;
import ru.yandex.calendar.logic.sharing.perm.LayerActionClass;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class LayerInvitationMailEventJson extends LogEvent {

    private final String messageId;
    private final String to;
    private final String from;
    private final long layerId;
    private final Optional<LayerActionClass> perm;
    private final String status;
    private final Optional<String> response;

    public LayerInvitationMailEventJson(
            LayerInvitationMessageParameters parameters,
            String messageId, String status, Optional<String> response
    ) {
        this.messageId = messageId;
        this.to = parameters.getRecipientEmail().getEmail();
        this.from = parameters.getSender().getEmail().getEmail();
        this.layerId = parameters.getLayerId();
        this.perm = parameters.getPerm().toOptional();
        this.status = status;
        this.response = response;
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.LAYER_INVITATION_MAIL;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.empty();
    }
}
