package ru.yandex.calendar.logic.sending;

import ru.yandex.calendar.logic.beans.generated.LayerInvitation;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class LayerSendingInfo {
    // Required fields
    private final LayerInvitation invitation;

    private final boolean autoAccept;
    private final boolean toParticipant;

    public LayerSendingInfo(LayerInvitation invitation, boolean autoAccept) {
        Validate.notNull(invitation);
        this.invitation = invitation;
        this.autoAccept = autoAccept;
        this.toParticipant = true;
    }

    public boolean isAutoAccept() {return autoAccept; }
    public boolean getToParticipant() {return toParticipant; }
    public LayerInvitation getInvitation() { return invitation; }

} //~
