package ru.yandex.calendar.logic.sending;

import java.util.Properties;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.boot.CalendarJdbcContextConfiguration;
import ru.yandex.calendar.logic.sending.real.ExtendedJavaMailSender;
import ru.yandex.calendar.logic.sending.real.JavaMailSender;
import ru.yandex.calendar.logic.sending.real.MailSender;
import ru.yandex.calendar.logic.sending.real.MailSenderMock;
import ru.yandex.calendar.logic.sending.real.ScheduleMailSender;
import ru.yandex.calendar.logic.sending.real.SmsSender;
import ru.yandex.calendar.util.wiki.WikiApiClientContextConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.property.PropertiesHolder;

@Configuration
@Import({
        WikiApiClientContextConfiguration.class,
        CalendarJdbcContextConfiguration.class,
})
public class SendingContextConfiguration {
    @Bean
    public MailSender mailSender(CalendarAppName calendarAppName, EnvironmentType environmentType) {
        if (calendarAppName == CalendarAppName.TEST || environmentType == EnvironmentType.TESTS) {
            return new MailSenderMock();
        } else {
            final Properties corpProperties = PropertiesHolder.properties();
            final String property = corpProperties.getProperty("mail.yt.smtp.host");
            if (StringUtils.isNotEmpty(property)) {
                corpProperties.setProperty("mail.smtp.host", property);
            }
            return new JavaMailSender(
                    new ExtendedJavaMailSender(PropertiesHolder.properties()),
                    new ExtendedJavaMailSender(corpProperties)
            );
        }
    }

    @Bean
    public SmsSender smsSender() {
        return new SmsSender();
    }

    @Bean
    public EventNotificationMessageXmlCreator eventNotificationMessageXmlCreator() {
        return new EventNotificationMessageXmlCreator();
    }

    @Bean
    public EventInvitationOrCancelMessageXmlCreator eventInvitationMessageXmlCreator() {
        return new EventInvitationOrCancelMessageXmlCreator();
    }

    @Bean
    public EventMarkupXmlCreator eventMarkupXmlCreator() {
        return new EventMarkupXmlCreator();
    }

    @Bean
    public ScheduleMailSender scheduleMailSender(){
        return new ScheduleMailSender();
    }
}
