package ru.yandex.calendar.logic.sending;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;
import ru.yandex.calendar.logic.sending.param.TodoMessageParameters;
import ru.yandex.calendar.logic.todo.TodoMailType;
import ru.yandex.inside.passport.AbstractPassportUid;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class TodoMailLogEventJson extends LogEvent {
    private final String messageId;
    private final TodoMailType mailType;
    private final String to;
    private final Optional<Long> uid;
    private final int itemsCount;
    private final int listsCount;
    private final String status;
    private final Optional<String> response;

    public TodoMailLogEventJson(
            TodoMessageParameters parameters,
            String messageId, String status, Optional<String> response
    ) {
        this.messageId = messageId;
        this.mailType = parameters.mailType;
        this.to = parameters.getRecipientEmail().getEmail();
        this.uid = parameters.recipient.getUid().map(AbstractPassportUid::getUid).toOptional();
        this.itemsCount = parameters.items.size();
        this.listsCount = parameters.lists.size();
        this.status = status;
        this.response = response;
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.TODO_MAIL;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.empty();
    }
}
