package ru.yandex.calendar.logic.sending.bazinga;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import ru.yandex.calendar.frontend.bender.IcsCalendarMarshaller;
import ru.yandex.calendar.frontend.bender.IcsCalendarUnmarshaller;
import ru.yandex.calendar.frontend.bender.InstantIso8601Marshaller;
import ru.yandex.calendar.frontend.bender.InstantIso8601Unmarshaller;
import ru.yandex.calendar.frontend.bender.LocalDateTimeNoMillisMarshaller;
import ru.yandex.calendar.frontend.bender.LocalDateTimeUnmarshaller;
import ru.yandex.calendar.frontend.bender.MailAddressMarshaller;
import ru.yandex.calendar.frontend.bender.MailAddressUnmarshaller;
import ru.yandex.calendar.frontend.bender.PassportSidMarshaller;
import ru.yandex.calendar.frontend.bender.PassportSidUnmarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailMarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailUnmarshaller;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.inside.passport.PassportSid;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.simpleType.LocalDateUnmarshaller;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.bender.serialize.simpleType.LocalDateMarshaller;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class MessageParametersBender {

    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(Email.class, new UnicodeEmailMarshaller(), new UnicodeEmailUnmarshaller())
                        .add(MailAddress.class, new MailAddressMarshaller(), new MailAddressUnmarshaller())
                        .add(LocalDateTime.class, new LocalDateTimeNoMillisMarshaller(), new LocalDateTimeUnmarshaller())
                        .add(LocalDate.class, new LocalDateMarshaller(), new LocalDateUnmarshaller())
                        .add(Instant.class, new InstantIso8601Marshaller(), new InstantIso8601Unmarshaller())
                        .add(DateTimeZone.class, new DateTimeZoneMarshaller(), new DateTimeZoneUnmarshaller())
                        .add(PassportSid.class, new PassportSidMarshaller(), new PassportSidUnmarshaller())
                        .add(IcsCalendar.class, new IcsCalendarMarshaller(), new IcsCalendarUnmarshaller())
                        .build());
    }

    public static class DateTimeZoneMarshaller extends StringValueMarshaller {
        @Override
        protected String toStringValue(Object o) {
            return ((DateTimeZone) o).getID();
        }
    }

    public static class DateTimeZoneUnmarshaller extends SimpleTypeUnmarshallerSupport {
        @Override
        protected Object convert(String o) {
            return DateTimeZone.forID(o);
        }
    }
}
