package ru.yandex.calendar.logic.sending.bazinga;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.SendingMail;
import ru.yandex.calendar.logic.beans.generated.SendingMailFields;
import ru.yandex.calendar.logic.beans.generated.SendingMailHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;

/**
 * @author dbrylev
 */
public class SendingMailDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public void insert(ListF<SendingMail> mails) {
        genericBeanDao.insertBeans(mails);
    }

    @RunWithRandomTest
    public ListF<SendingMail> findByJobId(UUID jobId) {
        return genericBeanDao.loadBeans(SendingMailHelper.INSTANCE, SendingMailFields.JOB_ID.eq(jobId));
    }

    @RunWithRandomTest
    public int deleteByJobId(UUID jobId) {
        return genericBeanDao.deleteBeans(SendingMailHelper.INSTANCE, SendingMailFields.JOB_ID.eq(jobId));
    }
}
