package ru.yandex.calendar.logic.sending.param;

import org.jdom.CDATA;
import org.jdom.Element;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.contact.UnivContact;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class ApartmentMessageParameters extends EventMessageParameters {
    private final MailType mailType;

    private final UnivContact organizer;
    private final ListF<UnivContact> customers;
    private final Option<String> address;
    private final Option<String> rules;

    @FillWithSomething
    public ApartmentMessageParameters(
            CommonEventMessageParameters commonMessageParameters,
            EventMessageInfo eventMessageInfo,
            MailType mailType, UnivContact organizer, ListF<UnivContact> customers,
            Option<String> address, Option<String> rules)
    {
        super(commonMessageParameters, eventMessageInfo);
        this.mailType = mailType;
        this.organizer = organizer;
        this.customers = customers;
        this.address = address;
        this.rules = rules;
    }

    @Override
    public ApartmentMessageParameters withMeta(CommonEventMessageParameters meta) {
        return new ApartmentMessageParameters(meta, event, mailType, organizer, customers, address, rules);
    }

    @Override
    public MailType mailType() {
        return mailType;
    }

    @Override
    public Element toOldStyleXml() {
        Element r = super.toOldStyleXml();

        CalendarXmlizer.appendElm(r, "organizer", organizer.getNameOrEmail());
        CalendarXmlizer.appendElmColl(r, "customers", "customer", customers.map(UnivContact::getNameOrEmail));
        CalendarXmlizer.appendElm(r, "mail-type", mailType);

        address.forEach(adr ->  CalendarXmlizer.appendElm(r, "address", adr));

        if (rules.isPresent() && customers.exists(c -> c.getEmail().equals(getRecipientEmail()))) {
            Element rulesEl = new Element("rules");
            rulesEl.addContent(new CDATA(rules.get()));
            r.addContent(rulesEl);
        }

        return r;
    }
}
