package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class BrokenDisplayReportMessageParameters extends OverridableMessageParameters {

    private final MailAddress sender;
    private final MailAddress recipient;
    private final BrokenDisplayResourceParameters brokenResource;

    public BrokenDisplayReportMessageParameters(
            MailAddress sender, MailAddress recipient, ResourceInfo brokenResource)
    {
        this(MessageOverrides.EMPTY, sender, recipient, BrokenDisplayResourceParameters.of(brokenResource));
    }

    @FillWithSomething
    public BrokenDisplayReportMessageParameters(
            MessageOverrides overrides,
            MailAddress sender, MailAddress recipient, BrokenDisplayResourceParameters brokenResource)
    {
        super(overrides);
        this.sender = sender;
        this.recipient = recipient;
        this.brokenResource = brokenResource;
    }

    @Override
    public Element toOldStyleXml() {
        Element message = new Element("message");

        Element resourceEl = CalendarXmlizer.appendElm(message, "resource");
        BrokenDisplayResourceParameters resource = brokenResource;

        CalendarXmlizer.appendElm(resourceEl, "name", resource.getName());
        CalendarXmlizer.appendElm(resourceEl, "name-with-alter", resource.getNameWithAlter());

        CalendarXmlizer.appendElm(resourceEl, "location", Cf.list(resource.getOfficeName())
                .plus(resource.getFloorNum().map(num -> num + "-й этаж"))
                .plus(resource.getGroupName()).mkString(", "));

        resource.getMapUrl().forEach(link -> CalendarXmlizer.appendElm(resourceEl, "map-url", link));

        CalendarXmlizer.appendElm(message, "to", recipient.getEmail().getEmail());
        CalendarXmlizer.appendElm(message, "nick", recipient.getPersonal());
        CalendarXmlizer.appendElm(message, "sender-email", sender.getEmail().getEmail());
        CalendarXmlizer.appendElm(message, "sender-nick", sender.getPersonal());

        return message;
    }

    @Override
    public Recipient getRecipient() {
        return Recipient.of(recipient, Option.empty());
    }

    @Override
    public MailType mailType() {
        return MailType.BROKEN_DISPLAY_REPORT;
    }

    @Override
    public OverridableMessageParameters withOverrides(MessageOverrides overrides) {
        return new BrokenDisplayReportMessageParameters(overrides, sender, recipient, brokenResource);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{"
                + "resource=" + brokenResource.getExchangeName()
                + ", to=" + getRecipientEmail()
                + "}";
    }
}
