package ru.yandex.calendar.logic.sending.param;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.util.rr.FillWithAllArgsConstructor;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
@FillWithAllArgsConstructor
public class BrokenDisplayResourceParameters {
    private final String exchangeName;
    private final String name;
    private final String nameWithAlter;
    private final String officeName;
    private final Option<Integer> floorNum;
    private final Option<String> groupName;
    private final Option<String> mapUrl;

    public static BrokenDisplayResourceParameters of(ResourceInfo resource) {
        return new BrokenDisplayResourceParameters(
                resource.getExchangeName(), resource.getName().get(),
                resource.getNameWithAlterName().get(), resource.getOffice().getName(),
                resource.getFloorNum(), resource.getResource().getGroupName(), resource.getStaffMapLink());
    }
}
