package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.annotation.SampleValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 *
 * @see InvitationMessageParameters
 */
@BenderBindAllFields
public class CancelEventMessageParameters extends EventMessageParameters {
    private final MailType mailType;

    @FillWithSomething
    public CancelEventMessageParameters(
            CommonEventMessageParameters commonMessageParameters, EventMessageInfo eventMessageInfo,
            Option<IcsCalendar> ics, @SampleValue("event-cancel") MailType mailType)
    {
        super(commonMessageParameters, eventMessageInfo, ics);
        Validate.V.isTrue(mailType == MailType.EVENT_CANCEL);
        this.mailType = mailType;
    }

    @Override
    public CancelEventMessageParameters withMeta(CommonEventMessageParameters meta) {
        return new CancelEventMessageParameters(meta, event, ics, mailType);
    }

    @Override
    public MailType mailType() {
        return mailType;
    }

    @Override
    public Element toOldStyleXml() {
        Element r = super.toOldStyleXml();

        ics.forEach(c -> CalendarXmlizer.appendElm(r, "ics-method", c.getMethod().getValue()));
        ics.forEach(c -> CalendarXmlizer.appendElm(r, "ics", c.serializeToString()));

        return r;
    }
} //~
