package ru.yandex.calendar.logic.sending.param;

import java.util.Objects;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.EventChangesInfoForMails;
import ru.yandex.calendar.logic.user.Language;

public class EventInviteeKey {
    public final long eventId;
    public final Option<EventChangesInfoForMails> changesInfo;
    public final Language language;

    public EventInviteeKey(long eventId, Option<EventChangesInfoForMails> changesInfo, Language language) {
        this.eventId = eventId;
        this.changesInfo = changesInfo;
        this.language = language;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventInviteeKey key = (EventInviteeKey) o;
        return eventId == key.eventId
                && language == key.language
                && changesInfo.equals(key.changesInfo); // hack: we are using only reference == for changesInfo
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventId, language, changesInfo);
    }
}
