package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18nWithOptionality;
import ru.yandex.calendar.logic.user.NameWithOptionality;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class EventInviteeNames {
    private static final int NAMES_LIMIT = 20;

    private final ListF<NameWithOptionality> current;
    private final ListF<NameWithOptionality> added;
    private final ListF<NameWithOptionality> removed;

    private final int currentTotal;
    private final int addedTotal;
    private final int removedTotal;

    public EventInviteeNames(ListF<NameWithOptionality> current, ListF<NameWithOptionality> added, ListF<NameWithOptionality> removed) {
        this.current = current;
        this.added = added;
        this.removed = removed;

        this.currentTotal = current.size();
        this.addedTotal = added.size();
        this.removedTotal = removed.size();
    }

    @FillWithSomething
    public EventInviteeNames(EventInviteeNamesI18n names, Language lang) {
        this(names.current.take(NAMES_LIMIT).map(NameI18nWithOptionality.getNameWithOptionalityF(lang)),
                names.added.take(NAMES_LIMIT).map(NameI18nWithOptionality.getNameWithOptionalityF(lang)),
                names.removed.take(NAMES_LIMIT).map(NameI18nWithOptionality.getNameWithOptionalityF(lang)));
    }

    private void appendWithTotal(Element parent, String collName, String itemName, ListF<String> values, int total) {
        Element e = CalendarXmlizer.createElmColl(collName, itemName, values);
        e.setAttribute("total", "" + total);

        parent.addContent(e);
    }

    public void addXmlTo(Element e) {
        if (current.isNotEmpty()) {
            Element currentAttendeesElement = new Element("guests");

            ListF<String> requiredAttendeeNames = current.filterNot(NameWithOptionality::isOptional)
                    .map(NameWithOptionality::getName);
            ListF<String> optionalAttendeeNames = current.filter(NameWithOptionality::isOptional)
                    .map(NameWithOptionality::getName);

            if (requiredAttendeeNames.isNotEmpty()) {
                appendWithTotal(currentAttendeesElement, "required-guests", "guest", requiredAttendeeNames, currentTotal);
            }
            if (optionalAttendeeNames.isNotEmpty()) {
                appendWithTotal(currentAttendeesElement, "optional-guests", "guest", optionalAttendeeNames, currentTotal);
            }

            e.addContent(currentAttendeesElement);
        }

        Element c = new Element("guests-changes");
        if (added.isNotEmpty()) {
            ListF<String> requiredAttendeeNames = added.filterNot(NameWithOptionality::isOptional)
                    .map(NameWithOptionality::getName);
            ListF<String> optionalAttendeeNames = added.filter(NameWithOptionality::isOptional)
                    .map(NameWithOptionality::getName);

            if (requiredAttendeeNames.isNotEmpty()) {
                appendWithTotal(c, "new-required-guests", "guest", requiredAttendeeNames, addedTotal);
            }
            if (optionalAttendeeNames.isNotEmpty()) {
                appendWithTotal(c, "new-optional-guests", "guest", optionalAttendeeNames, addedTotal);
            }
        }

        if (removed.isNotEmpty()) {
            ListF<String> requiredAttendeeNames = removed.filterNot(NameWithOptionality::isOptional)
                    .map(NameWithOptionality::getName);
            ListF<String> optionalAttendeeNames = removed.filter(NameWithOptionality::isOptional)
                    .map(NameWithOptionality::getName);

            if (requiredAttendeeNames.isNotEmpty()) {
                appendWithTotal(c, "rem-required-guests", "guest", requiredAttendeeNames, removedTotal);
            }
            if (optionalAttendeeNames.isNotEmpty()) {
                appendWithTotal(c, "rem-optional-guests", "guest", optionalAttendeeNames, removedTotal);
            }
        }
        if (added.isNotEmpty() || removed.isNotEmpty()) {
            e.addContent(c);
        }
    }
}
