package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.EventChangesInfoForMails;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class EventMessageChanged {

    private final ListF<Field> fields;

    public EventMessageChanged(ListF<Field> fields) {
        this.fields = fields;
    }

    @FillWithSomething
    public EventMessageChanged(EventChangesInfoForMails info) {
        this(Cf.<Field>list()
                .plus(Option.when(info.isDescriptionChanged(), Field.DESCRIPTION))
                .plus(Option.when(info.isTimeOrRepetitionChanged(), Field.TIME))
                .plus(Option.when(info.isOrganizerChanged(), Field.ORGANIZER))
                .plus(Option.when(info.isLocationChanged(), Field.LOCATION))
                .plus(Option.when(info.isGuestsChanged(), Field.GUESTS))
                .plus(Option.when(info.isNameChanged(), Field.NAME)));
    }

    public Element toXml(String elementName) {
        Element element = new Element(elementName);

        CalendarXmlizer.appendElm(element, "when", fields.containsTs(Field.TIME));
        CalendarXmlizer.appendElm(element, "name", fields.containsTs(Field.NAME));
        CalendarXmlizer.appendElm(element, "description", fields.containsTs(Field.DESCRIPTION));
        CalendarXmlizer.appendElm(element, "location", fields.containsTs(Field.LOCATION));
        CalendarXmlizer.appendElm(element, "organizer", fields.containsTs(Field.ORGANIZER));
        CalendarXmlizer.appendElm(element, "guests", fields.containsTs(Field.GUESTS));

        return element;
    }

    public ListF<Field> getFields() {
        return fields;
    }

    public enum Field {
        TIME,
        NAME,
        DESCRIPTION,
        LOCATION,
        ORGANIZER,
        GUESTS,
    }
}
