package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.annotation.SampleValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * XXX ssytnik: only used for secondary-tz-suffix -- simplify it
 * @author Stepan Koltsov
 */
@BenderBindAllFields
public class EventMessageTimezone {
    private final Option<String> id;
    private final String offsetFormatted;

    @FillWithSomething
    public EventMessageTimezone(
            @SampleValue("some(Europe/Moscow)") Option<String> id, @SampleValue("+04:00") String offsetFormatted)
    {
        this.id = id;
        this.offsetFormatted = offsetFormatted;
    }

    public void appendToXml(Element e) {
        // ssytnik@: due to CAL-4505, suffix is always shown now. This was changed on 19th of Dec 2011.
        String secondaryTzSuffix = id.plus("GMT" + offsetFormatted).mkString(" (", ", ", ")");
        CalendarXmlizer.appendElm(e, "secondary-tz-suffix", secondaryTzSuffix);
    }

    public static EventMessageTimezone create(DateTimeZone tz, Instant instant) {
        Option<String> id = !tz.isFixed() ? Option.of(tz.getID()) : Option.<String>empty();

        return new EventMessageTimezone(id, AuxDateTime.formatOffset(tz.getOffset(instant)));
    }

} //~
