package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.LayerUser;
import ru.yandex.calendar.logic.event.EventChangesInfoForMails;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class EventOnLayerChangeMessageParameters extends EventMessageParameters {

    private final long layerId;
    private final String layerName;
    private final Option<Integer> layerColor;
    private final boolean showActor;
    private final MailType mailType;
    private final Option<EventMessageChanged> changed;
    private final EventInviteeNames guests;

    @FillWithSomething
    public EventOnLayerChangeMessageParameters(
            CommonEventMessageParameters commonMessageParameters,
            EventMessageInfo eventMessageInfo,
            LayerUser layerUser, String layerName, boolean showActor, MailType mailType,
            Option<EventChangesInfoForMails> changed, EventInviteeNamesI18n guests)
    {
        this(commonMessageParameters, eventMessageInfo,
                layerUser.getLayerId(), layerName, layerUser.getHeadBgColor(),
                showActor, mailType, changed.map(EventMessageChanged::new),
                new EventInviteeNames(guests, commonMessageParameters.getLanguage()));
    }

    public EventOnLayerChangeMessageParameters(
            CommonEventMessageParameters meta, EventMessageInfo event,
            long layerId, String layerName,
            Option<Integer> layerColor, boolean showActor, MailType mailType,
            Option<EventMessageChanged> changed, EventInviteeNames guests)
    {
        super(meta, event);
        this.layerId = layerId;
        this.layerName = layerName;
        this.layerColor = layerColor;
        this.showActor = showActor;
        this.mailType = mailType;
        this.changed = changed;
        this.guests = guests;
    }

    @Override
    public EventOnLayerChangeMessageParameters withMeta(CommonEventMessageParameters meta) {
        return new EventOnLayerChangeMessageParameters(meta, event, layerId, layerName, layerColor, showActor, mailType, changed, guests);
    }

    @Override
    public MailType mailType() {
        return mailType;
    }

    @Override
    public Element toOldStyleXml() {
        Element r = super.toOldStyleXml();

        CalendarXmlizer.appendElm(r, "show-actor", showActor);
        CalendarXmlizer.appendElm(r, "layer-name", layerName);

        if (layerColor.isPresent()) {
            CalendarXmlizer.appendElm(r, "layer-color", "#" + Integer.toHexString(layerColor.get()));
        }
        guests.addXmlTo(r);

        if (changed.isPresent()) {
            r.addContent(changed.get().toXml("event-changes"));
        }
        return r;
    }

    public long getLayerId() {
        return layerId;
    }

    public static Function<EventOnLayerChangeMessageParameters, Long> getLayerIdF() {
        return new Function<EventOnLayerChangeMessageParameters, Long>() {
            public Long apply(EventOnLayerChangeMessageParameters p) {
                return p.getLayerId();
            }
        };
    }
}
