package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class EventOnResourceChangeMessageParameters extends EventMessageParameters {

    private final String resourceName;
    private final EventInviteeNames guests;
    private final Option<EventMessageChanged> changed;
    private final MailType mailType;

    @FillWithSomething
    public EventOnResourceChangeMessageParameters(
            CommonEventMessageParameters meta, EventMessageInfo event, String resourceName,
            EventInviteeNames guests, Option<EventMessageChanged> changed, MailType mailType)
    {
        super(meta, event);
        this.resourceName = resourceName;
        this.guests = guests;
        this.changed = changed;
        this.mailType = mailType;
    }

    @Override
    public EventOnResourceChangeMessageParameters withMeta(CommonEventMessageParameters meta) {
        return new EventOnResourceChangeMessageParameters(meta, event, resourceName, guests, changed, mailType);
    }

    @Override
    public MailType mailType() {
        return mailType;
    }

    @Override
    public Element toOldStyleXml() {
        Element r = super.toOldStyleXml();

        CalendarXmlizer.appendElm(r, "resource-name", resourceName);

        guests.addXmlTo(r);

        if (changed.isPresent()) {
            r.addContent(changed.get().toXml("event-changes"));
        }
        return r;
    }
}
