package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.mail.MailBender;
import ru.yandex.calendar.frontend.api.mail.MailEventChangesInfo;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.annotation.SampleValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.Validate;

/**
 *
 * @author Stepan Koltsov
 *
 */
@BenderBindAllFields
public class InvitationMessageParameters extends EventMessageParameters {
    private final Option<MailEventChangesInfo> infoForYaMail;
    private final Option<String> privateToken;
    private final EventInviteeNames guests;
    private final Option<EventMessageChanged> changed;
    private final Decision decision;
    private final boolean forOwner;
    private final MailType mailType;

    @FillWithSomething
    public InvitationMessageParameters(
            CommonEventMessageParameters commonMessageParameters, EventMessageInfo eventMessageInfo,
            Option<IcsCalendar> ics, Option<MailEventChangesInfo> infoForYaMail, Option<String> privateToken,
            EventInviteeNamesI18n guests, Option<EventMessageChanged> changed,
            Decision decision, boolean forOwner,
            @SampleValue({"event-invitation", "event-update"}) MailType mailType)
    {
        this(commonMessageParameters, eventMessageInfo, infoForYaMail, privateToken,
                new EventInviteeNames(guests, commonMessageParameters.getLanguage()),
                changed, decision, forOwner, mailType, ics);
    }

    public InvitationMessageParameters(
            CommonEventMessageParameters meta, EventMessageInfo event,
            Option<MailEventChangesInfo> infoForYaMail, Option<String> privateToken,
            EventInviteeNames guests, Option<EventMessageChanged> changed,
            Decision decision, boolean forOwner, MailType mailType, Option<IcsCalendar> ics)
    {
        super(meta, event, ics);
        Validate.V.isTrue(mailType.getDataClass().sameAs(InvitationMessageParameters.class), "got " + mailType);

        this.infoForYaMail = infoForYaMail;
        this.privateToken = privateToken;
        this.guests = guests;
        this.changed = changed;
        this.decision = decision;
        this.forOwner = forOwner;
        this.mailType = mailType;
    }

    @Override
    public InvitationMessageParameters withMeta(CommonEventMessageParameters meta) {
        return new InvitationMessageParameters(
                meta, event, infoForYaMail, privateToken, guests, changed, decision, forOwner, mailType, ics);
    }

    @Override
    public MailType mailType() {
        return mailType;
    }

    @Override
    public Element toOldStyleXml() {
        Element r = super.toOldStyleXml();

        ics.forEach(c -> CalendarXmlizer.appendElm(r, "ics", c.serializeToString()));

        infoForYaMail.forEach(info -> CalendarXmlizer.appendElm(
                r, "info-for-ya-mail", new String(MailBender.mapper.serializeJson(info))));

        if (privateToken.isPresent()) {
            CalendarXmlizer.appendElm(r, "private-token", privateToken.get());
        }

        guests.addXmlTo(r);

        CalendarXmlizer.appendElm(r, "decision", decision.toDbValue());
        CalendarXmlizer.appendElm(r, "for-organizer-or-creator", forOwner);

        if (changed.isPresent()) {
            r.addContent(changed.get().toXml("event-changes"));
        }

        return r;
    }
} //~
