package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.logic.sharing.perm.LayerActionClass;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.StringUtils;

@BenderBindAllFields
public class LayerInvitationMessageParameters extends OverridableMessageParameters {
    private final Language language;
    private final String layerName;
    private final long layerId;
    private final Option<LayerActionClass> perm;
    private final Sender sender;
    private final MailAddress recipient;
    private final Email emailFrom;
    private final Option<PassportUid> recipientUid;
    private final String calendarUrl;
    private final String privateToken;
    private final boolean autoAccept;

    @FillWithSomething
    public LayerInvitationMessageParameters(
            Language language,
            String layerName, long layerId, LayerActionClass perm,
            Sender sender, MailAddress recipient, Email emailFrom,
            Option<PassportUid> recipientUid, String calendarUrl, String privateToken, boolean autoAccept)
    {
        this(MessageOverrides.EMPTY, language, layerName, layerId, Option.of(perm),
                sender, recipient, emailFrom, recipientUid, calendarUrl, privateToken, autoAccept);
    }

    private LayerInvitationMessageParameters(
            MessageOverrides overrides,
            Language language,
            String layerName, long layerId, Option<LayerActionClass> perm,
            Sender sender, MailAddress recipient, Email emailFrom,
            Option<PassportUid> recipientUid, String calendarUrl, String privateToken, boolean autoAccept)
    {
        super(overrides);
        this.language = language;
        this.layerName = layerName;
        this.layerId = layerId;
        this.perm = perm;
        this.sender = sender;
        this.recipient = recipient;
        this.emailFrom = emailFrom;
        this.recipientUid = recipientUid;
        this.calendarUrl = calendarUrl;
        this.privateToken = privateToken;
        this.autoAccept = autoAccept;
    }

    @Override
    public MailType mailType() {
        return MailType.LAYER_INVITATION;
    }

    @Override
    public Element toOldStyleXml() {
        Element res = new Element("message");
        CalendarXmlizer.appendElm(res, "language", language.value());
        if (recipientUid.isPresent()) {
            CalendarXmlizer.appendElm(res, "uid", recipientUid.get().getUid());
        }
        CalendarXmlizer.appendElm(res, "layer-name", layerName);
        CalendarXmlizer.appendElm(res, "layer-id", layerId);
        CalendarXmlizer.appendElm(res, "to", recipient.getEmail().getEmail());
        CalendarXmlizer.appendElm(res, "nick", recipient.getPersonal());
        CalendarXmlizer.appendElm(res, "calendar-url", calendarUrl);
        CalendarXmlizer.appendElm(res, "sender-email", sender.getEmail().getEmail());
        CalendarXmlizer.appendElm(res, "sender-nick", StringUtils.defaultIfEmpty(
                sender.getName().getName(language), Emails.getUnicoded(sender.getEmail())));
        CalendarXmlizer.appendElm(res, "email-from", emailFrom.getEmail());
        CalendarXmlizer.appendElm(res, "private-token", privateToken);
        if (autoAccept) {
            CalendarXmlizer.appendElm(res, "auto");
        }
        return res;
    }

    @Override
    public Recipient getRecipient() {
        return Recipient.of(recipient, Option.empty());
    }

    @Override
    public OverridableMessageParameters withOverrides(MessageOverrides overrides) {
        return new LayerInvitationMessageParameters(overrides,
                language, layerName, layerId, perm, sender, recipient,
                emailFrom, recipientUid, calendarUrl, privateToken, autoAccept);
    }

    public String getPrivateToken() {
        return privateToken;
    }

    public boolean isAutoAccept() {
        return autoAccept;
    }

    public long getLayerId() {
        return layerId;
    }

    public String getLayerName() {
        return layerName;
    }

    public Option<LayerActionClass> getPerm() {
        return perm;
    }

    public Sender getSender() {
        return sender;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{"
                + "layerId=" + layerId
                + ", to=" + getRecipientEmail()
                + "}";
    }
} //~
