package ru.yandex.calendar.logic.sending.param;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class MessageOverrides {
    public static final MessageOverrides EMPTY = new MessageOverrides(
            Option.empty(), Option.empty(), Option.empty(), Option.empty());

    public final Option<Instant> date;
    public final Option<String> messageId;
    public final Option<String> subject;
    public final Option<MessageDestination> destination;

    public MessageOverrides(MessageDestination destination) {
        this(Option.empty(), Option.empty(), Option.empty(), Option.of(destination));
    }

    @FillWithSomething
    public MessageOverrides(
            Option<Instant> date, Option<String> messageId,
            Option<String> subject, Option<MessageDestination> destination)
    {
        this.date = date;
        this.messageId = messageId;
        this.subject = subject;
        this.destination = destination.filterNot(MessageDestination.ANYWHERE::equals);
    }

    public MessageOverrides withDate(Instant date) {
        return new MessageOverrides(Option.of(date), messageId, subject, destination);
    }

    public MessageOverrides withMessageId(String messageId) {
        return new MessageOverrides(date, Option.of(messageId), subject, destination);
    }

    public boolean isEmpty() {
        return !(date.isPresent() || messageId.isPresent() || subject.isPresent() || destination.isPresent());
    }
}
