package ru.yandex.calendar.logic.sending.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

import org.jdom.Element;
import org.springframework.jdbc.support.SqlValue;

import ru.yandex.calendar.logic.sending.bazinga.MessageExtraDao;
import ru.yandex.calendar.logic.sending.bazinga.MessageParametersBender;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.commune.bazinga.pg.storage.dao.support.JsonSqlValue;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.bender.annotation.SubclassTypeDefinition;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
@BenderBindAllFields
@BenderParseSubclasses(typeDefinition = SubclassTypeDefinition.FIELD, value = {
        ApartmentMessageParameters.class,
        CancelEventMessageParameters.class,
        EventOnLayerChangeMessageParameters.class,
        EventOnResourceChangeMessageParameters.class,
        InvitationMessageParameters.class,
        NotificationMessageParameters.class,
        ReplyMessageParameters.class,
        LayerInvitationMessageParameters.class,
        TodoMessageParameters.class,
        TodoListMessageParameters.class,
        BrokenDisplayReportMessageParameters.class,
        RepetitionConfirmationMessageParameters.class,
})
public abstract class MessageParameters implements SqlValue {
    public static final BenderParser<MessageParameters> parser = Bender.parser(
            MessageParameters.class, MessageParametersBender.getConfiguration());

    public static final BenderSerializer<MessageParameters> serializer = Bender.serializer(
            MessageParameters.class, MessageParametersBender.getConfiguration());

    public abstract Element toOldStyleXml();
    public abstract MailType mailType();
    public abstract Recipient getRecipient();

    public abstract MessageParameters withOverrides(MessageOverrides overrides);
    public abstract MessageOverrides getMessageOverrides();
    public void loadExtra(MessageExtraDao messageExtraDao) {
    }

    @Override
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        String json = new String(serializer.serializeJson(this));

        ps.setObject(paramIndex, JsonSqlValue.escapeJson(json), Types.OTHER);
    }

    @Override
    public void cleanup() {
    }

    public Email getRecipientEmail() {
        return getRecipient().address.getEmail();
    }
} //~
