package ru.yandex.calendar.logic.sending.param;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.contact.UnivContact;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;

@BenderBindAllFields
public class Recipient {
    public final MailAddress address;
    public final Option<PassportUid> uid;
    public final Option<String> login;
    public final boolean isOutlooker;

    @FillWithSomething
    public Recipient(
            MailAddress address, Option<PassportUid> uid, Option<String> login, boolean isOutlooker)
    {
        this.address = address;
        this.uid = uid;
        this.login = login;
        this.isOutlooker = isOutlooker;
    }

    public static Recipient of(SettingsInfo settings) {
        return new Recipient(
                new MailAddress(settings.getEmail()), Option.of(settings.getUid()),
                settings.getUserLogin(), settings.isOutlookerOrEwser());
    }

    public static Recipient of(MailAddress address, Option<SettingsInfo> settings) {
        return settings.isPresent() ? of(settings.get())
                : new Recipient(address, Option.empty(), Option.empty(), false);
    }

    public static Recipient of(UnivContact contact, Option<SettingsInfo> settings) {
        return settings.isPresent() ? of(settings.get())
                : new Recipient(contact.getMailAddress(), contact.getUid(), Option.empty(), false);
    }

    public Option<PassportUid> getUid() {
        return uid;
    }

    public Email getEmail() {
        return address.getEmail();
    }

    @Override
    public String toString() {
        return "Recipient{" +
                "address=" + address +
                ", uid=" + uid +
                ", login=" + login +
                ", isOutlooker=" + isOutlooker +
                '}';
    }
}
