package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.annotation.SampleValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class RepetitionConfirmationMessageParameters extends OverridableMessageParameters {

    private final Language language;
    private final long eventId;

    private final String eventName;
    private final String repetitionDescription;
    private final String roomName;
    private final LocalDateTime deadline;

    private final MailAddress sender;
    private final MailAddress recipient;
    private final String calendarUrl;

    @FillWithSomething
    public RepetitionConfirmationMessageParameters(
            Language language, long eventId,
            String eventName, String repetitionDescription, String roomName, LocalDateTime deadline,
            MailAddress sender, MailAddress recipient,
            @SampleValue("http://calendar.yandex-team.ru/") String calendarUrl)
    {
        this(MessageOverrides.EMPTY,
                language, eventId, eventName, repetitionDescription,
                roomName, deadline, sender, recipient, calendarUrl);
    }

    private RepetitionConfirmationMessageParameters(MessageOverrides overrides,
            Language language, long eventId, String eventName, String repetitionDescription,
            String roomName, LocalDateTime deadline, MailAddress sender, MailAddress recipient, String calendarUrl)
    {
        super(overrides);
        this.language = language;
        this.eventId = eventId;
        this.eventName = eventName;
        this.repetitionDescription = repetitionDescription;
        this.roomName = roomName;
        this.deadline = deadline;
        this.sender = sender;
        this.recipient = recipient;
        this.calendarUrl = calendarUrl;
    }

    @Override
    public Element toOldStyleXml() {
        Element message = new Element("message");
        CalendarXmlizer.appendElm(message, "language", language.value());
        CalendarXmlizer.appendElm(message, "event-id", eventId);

        CalendarXmlizer.appendElm(message, "event-name", eventName);
        CalendarXmlizer.appendElm(message, "repetition-description", repetitionDescription);
        CalendarXmlizer.appendElm(message, "room-name", roomName);
        CalendarXmlizer.appendElm(message, "deadline", deadline);

        CalendarXmlizer.appendElm(message, "to", recipient.getEmail().getEmail());
        CalendarXmlizer.appendElm(message, "nick", recipient.getPersonal());
        CalendarXmlizer.appendElm(message, "sender-email", sender.getEmail().getEmail());
        CalendarXmlizer.appendElm(message, "sender-nick", sender.getPersonal());
        CalendarXmlizer.appendElm(message, "calendar-url", calendarUrl);
        return message;
    }

    @Override
    public Recipient getRecipient() {
        return Recipient.of(recipient, Option.empty());
    }

    @Override
    public MailType mailType() {
        return MailType.REPETITION_CONFIRMATION;
    }

    @Override
    public OverridableMessageParameters withOverrides(MessageOverrides overrides) {
        return new RepetitionConfirmationMessageParameters(overrides,
                language, eventId, eventName, repetitionDescription,
                roomName, deadline, sender, recipient, calendarUrl);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "{"
                + "eventId=" + eventId
                + ", to=" + getRecipientEmail()
                + "}";
    }
}
