package ru.yandex.calendar.logic.sending.param;

import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.resource.SpecialResources;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class ReplyMessageParameters extends EventMessageParameters {
    private final Decision decision;
    private final Option<String> reason;
    private final MailType mailType;
    private final Option<SpecialResources.RoomsDisplaySettings> displaySettings;
    private final boolean forceDelayedSending;

    @FillWithSomething
    public ReplyMessageParameters(
            CommonEventMessageParameters commonEventMessageParameters, EventMessageInfo eventMessageInfo,
            Decision decision, Option<String> reason, Option<IcsCalendar> ics, MailType mailType)
    {
        this(commonEventMessageParameters, eventMessageInfo, decision, reason, ics, mailType, Option.empty(), false);
    }

    public ReplyMessageParameters(
            CommonEventMessageParameters commonEventMessageParameters, EventMessageInfo eventMessageInfo,
            Decision decision, Option<String> reason, Option<IcsCalendar> ics, MailType mailType,
            Option<SpecialResources.RoomsDisplaySettings> displaySettings, boolean forceDelayedSending)
    {
        super(commonEventMessageParameters, eventMessageInfo, ics);
        this.decision = decision;
        this.reason = reason;
        this.mailType = mailType;
        this.displaySettings = displaySettings;
        this.forceDelayedSending = forceDelayedSending;
    }

    public ReplyMessageParameters withForceDelayedSending() {
        return new ReplyMessageParameters(meta, event, decision, reason, ics, mailType, displaySettings, true);
    }

    @Override
    public ReplyMessageParameters withMeta(CommonEventMessageParameters meta) {
        return new ReplyMessageParameters(meta, event, decision, reason, ics, mailType, displaySettings, forceDelayedSending);
    }

    @Override
    public MailType mailType() {
        return mailType;
    }

    @Override
    public Element toOldStyleXml() {
        Element r = super.toOldStyleXml();

        if (reason.isPresent()) {
            CalendarXmlizer.appendElm(r, "reason", reason.get());
        }
        if (mailType == MailType.RESOURCE_UNCHECKIN) {
            SpecialResources.RoomsDisplaySettings settings =
                    displaySettings.getOrElse(SpecialResources::getDefaultDisplaySettings);

            if (event.time.repetition.isPresent()) {
                CalendarXmlizer.appendElm(r, "special-reason", "resource-total-uncheckin");
                CalendarXmlizer.appendElm(r, "times-in-a-row", settings.getTimesToTotalDecline());
            } else {
                CalendarXmlizer.appendElm(r, "special-reason", "resource-uncheckin");
                CalendarXmlizer.appendElm(r, "minutes-waited", settings.getCheckInEnd());
            }
        }
        CalendarXmlizer.appendElm(r, "decision", decision.toDbValue());
        ics.forEach(c -> CalendarXmlizer.appendElm(r, "ics", c.serializeToString()));

        return r;
    }

    public Decision getDecision() {
        return decision;
    }

    public boolean forceDelayedSending() {
        return forceDelayedSending;
    }
} //~
