package ru.yandex.calendar.logic.sending.param;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffUser.Gender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;

@Value
@BenderBindAllFields
public class Sender {
    Option<PassportUid> uid;
    Option<String> login;
    NameI18n name;
    Option<Gender> gender;
    Email email;

    public MailAddress getMailAddress(Language lang) {
        return new MailAddress(email, name.getName(lang));
    }
}
