package ru.yandex.calendar.logic.sending.param;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
public class TodoItemParameters {
    private final String title;
    private final Option<Instant> completionTs;
    private final Option<Instant> dueTs;

    public static TodoItemParameters of(TodoItem item) {
        return new TodoItemParameters(item.getTitle(), item.getCompletionTs(), item.getDueTs());
    }
}
