package ru.yandex.calendar.logic.sending.real;

import java.io.UnsupportedEncodingException;

import javax.mail.internet.MimeUtility;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.logic.domain.PassportAuthDomains;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.commune.mail.MailMessage;
import ru.yandex.misc.codec.FastBase64Coder;
import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.property.PropertiesHolder;

public class MailHacks {
    /**
     * Note, calendar-mailhook depends on X-Calendar-Request-Id header,
     * see http://wiki.yandex-team.ru/Calendar/Mailhook
     *
     * Add widget id for todo list email
     * see http://wiki.yandex-team.ru/Calendar/todo/MailSend
     */
    public static MailMessage addCalendarHeaders(MailMessage message, ActionInfo actionInfo) {
        return message
                .withHeader(MailHeaders.X_MAILER, MailHeaders.YA_CALENDAR)
                .withHeader(MailHeaders.X_CALENDAR_ENV, EnvironmentType.getActive().getValue())
                .withHeader(MailHeaders.X_CALENDAR_DOMAIN, getCalendarDomainHeader())
                .withHeader(MailHeaders.X_CALENDAR_REQUEST_ID, actionInfo.getRequestIdWithHostId())
                .withHeader(MailHeaders.X_CALENDAR_SERVER_HOST, HostnameUtils.localHostname())
                .withHeader(MailHeaders.X_CALENDAR_ACTION_SOURCE, actionInfo.getActionSource().toString());
    }

    public static MailMessage addCalendarHeaders(MailMessage message, MailType mailType, ActionInfo actionInfo) {
        MailMessage mes = addCalendarHeaders(message, actionInfo)
                .withHeader(MailHeaders.X_CALENDAR_MAIL_TYPE, mailType.toString().toLowerCase()); // CAL-4020

        if (mailType == MailType.TODO_LIST) {
            mes = addYatodoHeader(mes);
        } else {
            mes = addYacalHeader(mes);
        }

        return mes;
    }

    private static MailMessage addYatodoHeader(MailMessage mes) {
        return mes.withHeader(MailHeaders.X_YANDEX_WDGT_ID, "yatodo");
    }

    private static MailMessage addYacalHeader(MailMessage mes) {
        // X-YService (CAL-1029 / EML-4963)
        String yService = "yacal";
        String mixFull;
        try {
            mixFull = Cf.list(
                    mes.getHeader(MailHeaders.DATE).get(),
                    MimeUtility.decodeText(mes.getHeader(MailHeaders.FROM).get()),
                    mes.getSubject().getOrElse(""), yService, "76336c7a96b13f0258054d239e70fec8"
            ).mkString("_");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String md5 = Md5.A.digest(mixFull).hex();
        String xYandexService = FastBase64Coder.encode((yService + " " + md5));
        mes = mes.withHeader(MailHeaders.X_YANDEX_SERVICE, xYandexService);
        return mes;
    }

    private static String getCalendarDomainHeader() {
        return PassportAuthDomains.byProperty(PropertiesHolder.properties())
                .toString().toLowerCase();
    }

} //~
