package ru.yandex.calendar.logic.sending.real;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.sending.param.CancelEventMessageParameters;
import ru.yandex.calendar.logic.sending.param.EventMessageParameters;
import ru.yandex.calendar.logic.sending.param.InvitationMessageParameters;
import ru.yandex.calendar.logic.sending.param.LayerInvitationMessageParameters;
import ru.yandex.calendar.logic.sending.param.MessageParameters;
import ru.yandex.calendar.logic.sending.param.ReplyMessageParameters;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.commune.mail.MailMessage;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author akirakozov
 * @author ssytnik
 */
public class MailSenderMock implements MailSender {
    private final ListF<MessageParameters> messageParametersList = Cf.arrayList();

    @Override
    public synchronized void sendEmailsViaTask(ListF<? extends MessageParameters> messageParameterss, ActionInfo actionInfo) {
        messageParametersList.addAll(messageParameterss);
    }

    @Override
    public void send(DestinedMessage message, ActionInfo actionInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(Email recipient, MailMessage mail) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        messageParametersList.clear();
    }

    public <T extends MessageParameters> ListF<T> getMessageParameterss(Class<T> clazz) {
        return messageParametersList.filterByType(clazz);
    }

    public ListF<CancelEventMessageParameters> getCancelEventMessageParameterss() {
        return getMessageParameterss(CancelEventMessageParameters.class);
    }

    public ListF<InvitationMessageParameters> getInvitationMessageParameterss() {
        return getMessageParameterss(InvitationMessageParameters.class);
    }

    public ListF<ReplyMessageParameters> getReplyMessageParameterss() {
        return getMessageParameterss(ReplyMessageParameters.class);
    }

    public ListF<LayerInvitationMessageParameters> getLayerInvitationMessageParameterss() {
        return getMessageParameterss(LayerInvitationMessageParameters.class);
    }

    public ListF<EventMessageParameters> getEventMessageParameters() {
        return getMessageParameterss(EventMessageParameters.class);
    }

    public ListF<PassportUid> getEventRecipientUids() {
        return getEventMessageParameters().filterMap(EventMessageParameters.getRecipientUidF());
    }

    public ListF<MailType> getEventMailTypes() {
        return getEventMessageParameters().map(EventMessageParameters.mailTypeF());
    }

    public Option<MailType> findEventMailType(Email recipientEmail) {
        return getEventMessageParameters()
                .filter(EventMessageParameters.getRecipientEmailF().andThenEquals(recipientEmail))
                .map(EventMessageParameters.mailTypeF())
                .singleO();
    }

    public Option<MailType> findEventMailType(long eventId, Email recipientEmail) {
        return findEventMail(eventId, recipientEmail).map(EventMessageParameters::mailType);
    }

    public Option<EventMessageParameters> findEventMail(long eventId, Email recipientEmail) {
        return getEventMessageParameters()
                .filter(e -> e.getEventId() == eventId && e.getRecipientEmail().equalsIgnoreCase(recipientEmail))
                .singleO();
    }
}
