package ru.yandex.calendar.logic.sending.real;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.amazonaws.util.StringInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

import ru.yandex.inside.passport.sms.PassportSmsService;

/**
 * @author Sergey Galyamichev
 */
public class PassportSmsServiceMock extends PassportSmsService {
    public PassportSmsServiceMock() {
        super(new MockHttpClient());
    }

    public void addResponses(Map<String, String> responses) {
        MockHttpClient.urlToResponse.putAll(responses);
    }

    public void clear() {
        MockHttpClient.urlToResponse.clear();
    }

    static class MockHttpClient extends CloseableHttpClient {
        static Map<String, String> urlToResponse = new HashMap<>();
        @Override
        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
            if (urlToResponse.containsKey(request.getRequestLine().getUri())) {
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setContent(new StringInputStream(urlToResponse.get(request.getRequestLine().getUri())));
                BasicHttpResponse response = new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 200, "OK"));
                response.setEntity(entity);
                return new HttpResponseProxy(response);
            }
            return new HttpResponseProxy(new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 404, "Not Found")));
        }

        @Override
        public void close() {
        }

        @Override
        public HttpParams getParams() {
            return null;
        }

        @Override
        public ClientConnectionManager getConnectionManager() {
            return null;
        }
    }

    static class HttpResponseProxy implements CloseableHttpResponse {

        private final HttpResponse original;

        public HttpResponseProxy(final HttpResponse original) {
            this.original = original;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public StatusLine getStatusLine() {
            return original.getStatusLine();
        }

        @Override
        public void setStatusLine(final StatusLine statusline) {
            original.setStatusLine(statusline);
        }

        @Override
        public void setStatusLine(final ProtocolVersion ver, final int code) {
            original.setStatusLine(ver, code);
        }

        @Override
        public void setStatusLine(final ProtocolVersion ver, final int code, final String reason) {
            original.setStatusLine(ver, code, reason);
        }

        @Override
        public void setStatusCode(final int code) throws IllegalStateException {
            original.setStatusCode(code);
        }

        @Override
        public void setReasonPhrase(final String reason) throws IllegalStateException {
            original.setReasonPhrase(reason);
        }

        @Override
        public HttpEntity getEntity() {
            return original.getEntity();
        }

        @Override
        public void setEntity(final HttpEntity entity) {
            original.setEntity(entity);
        }

        @Override
        public Locale getLocale() {
            return original.getLocale();
        }

        @Override
        public void setLocale(final Locale loc) {
            original.setLocale(loc);
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return original.getProtocolVersion();
        }

        @Override
        public boolean containsHeader(final String name) {
            return original.containsHeader(name);
        }

        @Override
        public Header[] getHeaders(final String name) {
            return original.getHeaders(name);
        }

        @Override
        public Header getFirstHeader(final String name) {
            return original.getFirstHeader(name);
        }

        @Override
        public Header getLastHeader(final String name) {
            return original.getLastHeader(name);
        }

        @Override
        public Header[] getAllHeaders() {
            return original.getAllHeaders();
        }

        @Override
        public void addHeader(final Header header) {
            original.addHeader(header);
        }

        @Override
        public void addHeader(final String name, final String value) {
            original.addHeader(name, value);
        }

        @Override
        public void setHeader(final Header header) {
            original.setHeader(header);
        }

        @Override
        public void setHeader(final String name, final String value) {
            original.setHeader(name, value);
        }

        @Override
        public void setHeaders(final Header[] headers) {
            original.setHeaders(headers);
        }

        @Override
        public void removeHeader(final Header header) {
            original.removeHeader(header);
        }

        @Override
        public void removeHeaders(final String name) {
            original.removeHeaders(name);
        }

        @Override
        public HeaderIterator headerIterator() {
            return original.headerIterator();
        }

        @Override
        public HeaderIterator headerIterator(final String name) {
            return original.headerIterator(name);
        }

        @Override
        @Deprecated
        public HttpParams getParams() {
            return original.getParams();
        }

        @Override
        @Deprecated
        public void setParams(final HttpParams params) {
            original.setParams(params);
        }

        @Override
        public String toString() {
            return "HttpResponseProxy{" + original + '}';
        }
    }
}
