package ru.yandex.calendar.logic.sending.so;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.RemoteInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.sending.param.EventMessageInfo;
import ru.yandex.calendar.logic.sending.param.Sender;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.ip.IpAddress;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class SoRequestData {
    private static final BenderSerializer<SoRequestData> serializer = Bender.serializer(SoRequestData.class);

    @BenderPart(name = "operation_type", strictName = true)
    public final MailType operation;
    public final Option<String> yandexuid;
    public final Option<String> ip;
    public final User user;
    public final String subject;
    public final String description;
    public final String location;
    @BenderPart(name = "X-Yandex", strictName = true)
    public final Extended extended;

    public SoRequestData(
            MailType operation, RemoteInfo remoteInfo,
            User user, EventMessageInfo eventMessageInfo, Extended extended)
    {
        this(operation, remoteInfo, user,
                eventMessageInfo.getEventName(), eventMessageInfo.getEventDescription(),
                eventMessageInfo.getLocation().asTextForSms(Language.RUSSIAN), extended);
    }

    public SoRequestData(
            MailType operation, RemoteInfo remoteInfo, User user,
            String subject, String description, String location, Extended extended)
    {
        this.operation = operation;
        this.yandexuid = remoteInfo.yandexuid;
        this.ip = remoteInfo.ip.map(IpAddress::format);
        this.user = user;
        this.subject = subject;
        this.description = description;
        this.location = location;
        this.extended = extended;
    }

    @BenderBindAllFields
    public static class User {
        public final PassportUid uid;
        public final Option<String> login;

        public User(PassportUid uid, Option<String> login) {
            this.uid = uid;
            this.login = login;
        }

        public User(Sender sender) {
            this(sender.getUid().get(), sender.getLogin());
        }
    }

    @BenderBindAllFields
    public static class Extended {
        @BenderPart(name = "to_count", strictName = true)
        public final int toCount;
        public final ActionSource source;

        public Extended(int toCount, ActionSource source) {
            this.toCount = toCount;
            this.source = source;
        }
    }

    public String serializeToJson() {
        return new String(serializer.serializeJson(this));
    }
}
