package ru.yandex.calendar.logic.sharding;

import javax.annotation.PostConstruct;

import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class ShardingLocator {

    private final DynamicProperty<HostUidsToRedirect> hostsToRedirectUids = new DynamicProperty<>(
            "shardingLocator.hostsToRedirectUids",
            new HostUidsToRedirect(Cf.map()));

    private final DynamicProperty<ListF<Long>> hostingUids = new DynamicProperty<>(
            "shardingLocator.hostingUids",
            Cf.list());

    private volatile MapF<Long, String> uidToRedirectHost = Cf.map();

    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    public boolean isHostingHere(PassportUid uid) {
        return hostingUids.get().isNotEmpty()
                ? hostingUids.get().containsTs(uid.getUid())
                : getHostToRedirect(uid).isEmpty();
    }

    public Option<String> getHostToRedirect(PassportUid uid) {
        return uidToRedirectHost.getO(uid.getUid());
    }

    @PostConstruct
    public void setup() {
        dynamicPropertyManager.registerAndFireWatcher(
                hostsToRedirectUids,
                hosts -> uidToRedirectHost = hosts.hosts.entrySet()
                        .flatMap((e) -> e.getValue().map(u -> Tuple2.tuple(u, e.getKey())))
                        .toMap(Tuple2::get1, Tuple2::get2));
    }

    @BenderBindAllFields
    @AllArgsConstructor
    private static class HostUidsToRedirect {
        private final MapF<String, ListF<Long>> hosts;
    }
}
