package ru.yandex.calendar.logic.sharing;

import com.microsoft.schemas.exchange.services._2006.types.ResponseTypeType;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsPartStat;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * Invitation decision
 * @author akirakozov
 */
public enum Decision implements StringEnum {
    YES(IcsPartStat.ACCEPTED, ResponseTypeType.ACCEPT, "yes"),
    MAYBE(IcsPartStat.TENTATIVE, ResponseTypeType.TENTATIVE, "maybe"),
    NO(IcsPartStat.DECLINED, ResponseTypeType.DECLINE, "no"),
    UNDECIDED(IcsPartStat.NEEDS_ACTION, ResponseTypeType.UNKNOWN, "undecided");

    private final IcsPartStat partStat;
    private final ResponseTypeType respType;
    private final String title;

    private Decision(IcsPartStat partStat, ResponseTypeType respType, String title) {
        this.partStat = partStat;
        this.respType = respType;
        this.title = title;
    }

    @Override
    public String value() {
        return name().toLowerCase();
    }

    public String toDbValue() {
        return value();
    }

    public IcsPartStat getPartStat() { return partStat; }
    public ResponseTypeType getRespType() { return respType; }

    public boolean goes() {
        return this == YES || this == MAYBE;
    }

    public static Option<Decision> findByIcsPartStat(IcsPartStat stat) {
        for (Decision value : Decision.values()) {
            if (value.getPartStat().isSame(stat)) {
                return Option.of(value);
            }
        }
        return Option.empty();
    }

    public static Option<Decision> findByExchangeReponseType(ResponseTypeType respType) {
        if (respType == ResponseTypeType.ORGANIZER) {
            return Option.of(YES);
        }

        Decision[] values = Decision.values();
        for (Decision value : values) {
            if (value.getRespType() == respType) {
                return Option.of(value);
            }
        }
        return Option.empty();
    }

    public static Decision findByTitle(String title) {
        for (Decision decision : values()) {
            if (decision.title.equals(title)) {
                return decision;
            }
        }
        throw new IllegalArgumentException("Unknow title: " + title);
    }

    public static final StringEnumResolver<Decision> R = StringEnumResolver.r(Decision.class);
} //~
