package ru.yandex.calendar.logic.sharing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.sharing.participant.ParticipantInfo;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
public class DecisionWithSource extends DefaultObject {
    private final Decision decision;
    private final Option<ActionSource> source;

    public DecisionWithSource(Decision decision, Option<ActionSource> source) {
        this.decision = decision;
        this.source = source;
    }

    public DecisionWithSource(ParticipantInfo info) {
        this(info.getDecision(), info.getDecisionSource());
    }

    public static DecisionWithSource withoutSource(Decision decision) {
        return new DecisionWithSource(decision, Option.empty());
    }

    public boolean isFromExchangeOrMail() {
        return source.map(ActionSource::isFromExchangeOrMail).getOrElse(false);
    }

    public Decision getDecision() {
        return decision;
    }

    public Option<ActionSource> getSource() {
        return source;
    }
}
