package ru.yandex.calendar.logic.sharing;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * Invitation accepting type
 * @author akirakozov
 */
public enum InvAcceptingType implements StringEnum {
    /**
     * Servant sends an invitation e-mail to the user.
     * User receives invitation e-mail and decides what to do manually.
     */
    MANUAL,
    /**
     * Servant doesn't send invitation e-mail.
     * If user isn't busy at corresponding time, he automatically becomes
     * participant of the meeting.
     */
    AUTO,
    /**
     * It's the same as AUTO, but user is automatically invited to
     * all the events, which are created in his layer by another users
     */
    ROBOT,
    ;

    public static final StringEnumResolver<InvAcceptingType> R = StringEnumResolver.r(InvAcceptingType.class);

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    @Override
    public String value() {
        return toDbValue();
    }

}
