package ru.yandex.calendar.logic.sharing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.EventResource;
import ru.yandex.calendar.logic.event.model.EventUserCreature;
import ru.yandex.calendar.logic.sending.EventSendingInfo;

/**
 * @author dbrylev
 */
public class InvitationCreature {
    public final Option<EventSendingInfo> sendingInfo;
    public final Option<EventUserCreature> eventUser;
    public final Option<EventLayer> eventLayer;
    public final Option<EventResource> eventResource;
    public final Option<EventInvitation> eventInvitation;

    public InvitationCreature(
            Option<EventSendingInfo> sendingInfo,
            Option<EventUserCreature> eventUser,
            Option<EventLayer> eventLayer,
            Option<EventResource> eventResource,
            Option<EventInvitation> eventInvitation)
    {
        this.sendingInfo = sendingInfo;
        this.eventUser = eventUser;
        this.eventLayer = eventLayer;
        this.eventResource = eventResource;
        this.eventInvitation = eventInvitation;
    }

    public static InvitationCreature empty() {
        return new InvitationCreature(
                Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    public static InvitationCreature forExternal(EventInvitation invitation) {
        return new InvitationCreature(
                Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.of(invitation));
    }

    public static InvitationCreature forResource(EventResource resource) {
        return new InvitationCreature(
                Option.empty(), Option.empty(), Option.empty(), Option.of(resource), Option.empty());
    }

    public static InvitationCreature forUser(Option<EventLayer> layer, EventUserCreature user) {
        return new InvitationCreature(
                Option.empty(), Option.of(user), layer, Option.empty(), Option.empty());
    }

    public InvitationCreature withSendingInfo(EventSendingInfo sendingInfo) {
        return new InvitationCreature(
                Option.of(sendingInfo), eventUser, eventLayer, eventResource, eventInvitation);
    }
}
