package ru.yandex.calendar.logic.sharing;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.EventResource;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.sharing.participant.ParticipantData;
import ru.yandex.calendar.logic.sharing.participant.ParticipantId;
import ru.yandex.calendar.logic.user.SettingsInfo;

/**
 * @author dbrylev
 */
public class InvitationData {
    public final ParticipantId participantId;
    public final ParticipantData participantData;

    public final Option<EventUser> user;
    public final Option<Long> defaultLayerId;
    public final ListF<Notification> defaultNotifications;
    public final Option<SettingsInfo> settings;
    public final ListF<EventLayer> layers;

    public final Option<EventResource> resource;
    public final Option<EventInvitation> invitation;

    public InvitationData(
            ParticipantId participantId,
            ParticipantData participantData,
            Option<EventUser> user,
            Option<Long> defaultLayerId,
            ListF<Notification> defaultNotifications,
            Option<SettingsInfo> settings,
            ListF<EventLayer> layers,
            Option<EventResource> resource,
            Option<EventInvitation> invitation)
    {
        this.participantId = participantId;
        this.participantData = participantData;
        this.user = user;
        this.defaultLayerId = defaultLayerId;
        this.defaultNotifications = defaultNotifications;
        this.settings = settings;
        this.layers = layers;
        this.resource = resource;
        this.invitation = invitation;
    }
}
