package ru.yandex.calendar.logic.sharing;

import ru.yandex.calendar.logic.ics.IcsUtils;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.commune.mail.ContentType;
import ru.yandex.commune.mail.MailMessage;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
public class InvitationEmails {

    public static MailMessage createDummyIcsMessage(Email sender, Email recipient, String subject, String plainTextMessage, IcsCalendar ics) {
        return MailMessage.empty()
            .withSubject(subject)
            .withTo(recipient)
            .withFrom(sender)
            .withContentType(ContentType.MULTIPART_ALTERNATIVE)
            .addPart(plainTextMessage, ContentType.TEXT_PLAIN_UTF8)
            .addPart(ics.serializeToString(), IcsUtils.CALENDAR_MIME_TYPE_FULL);
    }

} //~
