package ru.yandex.calendar.logic.sharing;

/**
 * @author akirakozov
 */
public enum InvitationProcessingMode {
    /**
     * Save information about invited guest to the db.
     */
    SAVE_ONLY,
    /**
     * Save information about invited guest to the db and try to
     * attach events to the calendars of invited guests.
     */
    SAVE_ATTACH,
    /**
     * Save information about invited guest to the db, send emails
     * to invited guests and try to attach events to the calendars
     * of invited guests.
     */
    SAVE_ATTACH_SEND;

    public boolean isSend() {
        return this == SAVE_ATTACH_SEND;
    }
}
