package ru.yandex.calendar.logic.sharing;

import org.jdom.Comment;
import org.jdom.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.cmd.run.ui.resource.ResourceXmlizer;
import ru.yandex.calendar.logic.sharing.participant.ParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.ParticipantKind;
import ru.yandex.calendar.logic.sharing.participant.Participants;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;
import ru.yandex.calendar.logic.sharing.participant.YandexUserParticipantInfo;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class InvitationXmlizer {

    private static Element serializeParticipant(ParticipantInfo inv, Option<PassportUid> uid, boolean outResourceInfo) {
        Element eInv = new Element("invitation");

        eInv.addContent(new Comment(inv.toString().replace("--", "\u2013")));

        CalendarXmlizer.appendElm(eInv, "email", Emails.getUnicoded(inv.getEmail()));

        if (inv instanceof YandexUserParticipantInfo) {
            Option<String> login = ((YandexUserParticipantInfo) inv).getLogin();
            if (login.isPresent()) {
                CalendarXmlizer.appendElm(eInv, "login", login.get());
            }
        }

        CalendarXmlizer.appendElm(eInv, "uid", inv.getUid().map(PassportUid::getUid).getOrNull()); // XXX: uid is not needed in verstka
        CalendarXmlizer.appendElm(eInv, "name", uid.isPresent() && uid.get().isYandexTeamRu() ? inv.getHiddenName() : inv.getName());
        CalendarXmlizer.appendElm(eInv, "decision", inv.getDecision().toDbValue());
        CalendarXmlizer.appendElm(eInv, "reason", inv.getReason());

        if (inv.isOrganizer()) {
            CalendarXmlizer.appendElm(eInv, "creator");
        }

        if (inv.getUid().isPresent() && uid.isPresent() && inv.getUid().get().sameAs(uid.get())) {
            CalendarXmlizer.appendElm(eInv, "its-me");
        }

        CalendarXmlizer.appendElm(eInv, "is-resource", inv.getId().getKind() == ParticipantKind.RESOURCE);

        if (outResourceInfo && inv instanceof ResourceParticipantInfo) {
            eInv.addContent(ResourceXmlizer.toXml(((ResourceParticipantInfo) inv).getResourceInfo()));
        }
        return eInv;
    }

    public static Element serializeParticipants(Participants participants, Option<PassportUid> uid) {
        return serializeParticipants(participants, uid, false);
    }

    public static Element serializeParticipants(Participants participants, Option<PassportUid> uid, boolean outResourceInfo) {
        Element e = new Element("invitations");
        if (!participants.isMeeting()) {
            return e;
        }

        for (ParticipantInfo p : participants.getParticipants()) {
            e.addContent(serializeParticipant(p, uid, outResourceInfo));
        }

        return e;
    }

    public static Element serializeOrganizer(Participants participants, Option<PassportUid> uid) {
        Element e = new Element("invitations");
        if (participants.isMeeting()) {
            e.addContent(serializeParticipant(participants.getOrganizer(), uid, false));
        }
        return e;
    }

} //~
