package ru.yandex.calendar.logic.sharing;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.contact.UnivContact;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.idlent.YandexUser;
import ru.yandex.calendar.util.resources.UStringLiteral;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * Helps with obtaining user nick
 * for salutation in email or makeup
 * @author ssytnik
 */
public class Nick {

    private static final Logger logger = LoggerFactory.getLogger(
            Nick.class);

    private static final String DEFAULT_NULLABLE_NICK = null;
    private static final String DEFAULT_SENDER_NICK_CAP = UStringLiteral.YOUR_FRIEND;
    private static final String DEFAULT_RECIPIENT_NICK_CAP = UStringLiteral.DEAR_USER;

    private Nick() {}

    private static String get(Settings s, String defaultNick) {
        if (s == null) {
            return defaultNick;
        }
        return Cf.list(s.getUserName().getOrElse(""), s.getUserLogin().getOrElse(""))
                .find(Cf.String.emptyF().notF())
                .getOrElse(defaultNick);
    }

    private static String get(YandexUser yu, String defaultNick) {
        // ssytnik: NOTE CAL-877 for calls from the 'NtfRecalcAndSend'
        return yu != null ?
                defaultIfBlank(yu.getName().getOrNull(), yu.getLogin().getRawValue()) :
                defaultNick;
    }
    private static String get(UnivContact uc, String defaultNick) {
        return uc != null ? defaultIfBlank(uc.getName(), defaultNick) : defaultNick;
    }
    private static String get(String name, String defaultNick) {
        return defaultIfBlank(name, defaultNick);
    }
    private static String getBySettings(SettingsRoutines settingsRoutines, PassportUid uid, String defaultNick) {
        try {
            return get(settingsRoutines.getSettingsByUid(uid).getCommon(), defaultNick);
        } catch (CommandRunException e) {
            logger.warn(e, e);
            return defaultNick;
        }
    }

    // General nick
    public static String getNullable(SettingsRoutines settingsRoutines, PassportUid uid) {
        return getBySettings(settingsRoutines, uid, DEFAULT_NULLABLE_NICK);
    }

    // Recipient nick
    public static String getRecipient(Settings s) { return get(s, DEFAULT_RECIPIENT_NICK_CAP); }
    public static String getRecipient(YandexUser yu) { return get(yu, DEFAULT_RECIPIENT_NICK_CAP); }
    public static String getRecipient(UnivContact uc) { return get(uc, DEFAULT_RECIPIENT_NICK_CAP); }
    public static String getRecipient(String name) { return get(name, DEFAULT_RECIPIENT_NICK_CAP); }
    public static String getRecipient(SettingsRoutines settingsRoutines, PassportUid uid) {
        return getBySettings(settingsRoutines, uid, DEFAULT_RECIPIENT_NICK_CAP);
    }

    // Sender nick
    public static String getSender(SettingsRoutines settingsRoutines, PassportUid uid) {
        return getBySettings(settingsRoutines, uid, DEFAULT_SENDER_NICK_CAP);
    }
    public static String getSender(UnivContact uc) {
        return get(uc, DEFAULT_SENDER_NICK_CAP);
    }

    public static String defaultIfBlank(String string, String defaultString) {
        return StringUtils.isNotBlank(string) ? string : defaultString;
    }
}
