package ru.yandex.calendar.logic.sharing;

import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;

/**
 * @author ssytnik
 * @author akirakozov
 */
public class ParticipantChangesInfo {
    private final UserParticipantInfo oldParticipant;
    private final String newName;
    private final Decision newDecision;
    private final boolean newIsOrganizer;
    private final boolean newIsOptional;

    public ParticipantChangesInfo(UserParticipantInfo oldParticipant, boolean newIsOrganizer) {
        this(oldParticipant, oldParticipant.getHiddenName(),
                newIsOrganizer ? Decision.YES : oldParticipant.getDecision(), newIsOrganizer, oldParticipant.isOptional());
    }

    public ParticipantChangesInfo(
            UserParticipantInfo oldParticipant,
            String newName, Decision newDecision, boolean newIsOrganizer, boolean newIsOptional)
    {
        this.oldParticipant = oldParticipant;
        this.newName = newName;
        this.newDecision = newDecision;
        this.newIsOrganizer = newIsOrganizer;
        this.newIsOptional = newIsOptional;
    }

    public UserParticipantInfo getOldParticipantInfo() { return oldParticipant; }
    public String getNewName() { return newName; }
    public Decision getNewDecision() { return newDecision; }
    public boolean getNewIsOptional() {
        return newIsOptional;
    }

    public boolean isOptionalChanged() {
        return oldParticipant.isOptional() != newIsOptional;
    }

    public boolean decisionChanged() {
        return oldParticipant.getDecision() != newDecision;
    }

    public boolean nameChanged() {
        return !oldParticipant.getHiddenName().equals(newName);
    }

    protected ParticipantChangesInfo withDecision(Decision decision) {
        return new ParticipantChangesInfo(oldParticipant, newName, decision, newIsOrganizer, newIsOptional);
    }

    public static Function1B<ParticipantChangesInfo> becomesOrganizerF() {
        return c -> !c.oldParticipant.isOrganizer() && c.newIsOrganizer;
    }

    public static Function1B<ParticipantChangesInfo> becomesNotOrganizerF() {
        return c -> c.oldParticipant.isOrganizer() && !c.newIsOrganizer;
    }

    public static Function1B<? super ParticipantChangesInfo> wasAttendeeF() {
        return (Function1B<ParticipantChangesInfo>) participantChangesInfo -> participantChangesInfo.getOldParticipantInfo().isAttendee();
    }

    public static Function1B<? super ParticipantChangesInfo> decisionChangedF() {
        return (Function1B<ParticipantChangesInfo>) participantChangesInfo -> participantChangesInfo.decisionChanged();
    }

    public static Function1B<? super ParticipantChangesInfo> newDecisionIsYesF() {
        return (Function1B<ParticipantChangesInfo>) participantChangesInfo -> participantChangesInfo.getNewDecision() == Decision.YES;
    }

}
