package ru.yandex.calendar.logic.sharing;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.SequenceAndDtStamp;

/**
 * @author akirakozov
 */
public class ReplyInfo {
    private final Decision decision;
    private final Option<String> reason;
    private final SequenceAndDtStamp version;


    public ReplyInfo(Decision decision, String reason, SequenceAndDtStamp version) {
        this(decision, Option.of(reason), version);
    }

    public ReplyInfo(Decision decision, Option<String> reason, SequenceAndDtStamp version) {
        this.decision = decision;
        this.reason = reason;
        this.version = version;
    }

    public Decision getDecision() {
        return decision;
    }

    public Option<String> getReason() {
        return reason;
    }

    public SequenceAndDtStamp getVersion() {
        return version;
    }

    public Instant getDtstamp() {
        return version.getDtStamp();
    }

    public int getSequence() {
        return version.getSequence();
    }
}
