package ru.yandex.calendar.logic.sharing.participant;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
public final class ExternalUserParticipantInfo extends UserParticipantInfo {
    private final EventInvitation invitation;

    // why would invitatoin.getEmail() change, so we store it? // ssytnik@
    private final Email email;

    public ExternalUserParticipantInfo(EventInvitation invitation) {
        this.invitation = invitation;
        this.email = invitation.getEmail();
    }

    @Override
    public ParticipantId getId() {
        return ParticipantId.invitationIdForExternalUser(invitation.getEmail());
    }

    public EventInvitation getInvitation() {
        return invitation;
    }

    @Override
    public long getEventId() {
        return invitation.getEventId();
    }

    @Override
    public String getHiddenName() {
        return invitation.getName();
    }

    @Override
    public Decision getDecision() {
        return invitation.getDecision();
    }

    @Override
    public Option<ActionSource> getDecisionSource() {
        return invitation.getDecisionSource();
    }

    @Override
    public boolean isAttendee() {
        return true;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isOrganizer() {
        return invitation.getIsOrganizer();
    }

    @Override
    public Email getEmail() {
        return invitation.getEmail();
    }

    @Override
    public Option<PassportUid> getUid() {
        return Option.empty();
    }

    @Override
    public String getReason() {
        return invitation.getReason().getOrElse("");
    }

    @Override
    public Option<String> getExchangeId() {
        return Option.<String>empty();
    }

    public static Function<EventInvitation, ExternalUserParticipantInfo> consF() {
        return new Function<EventInvitation, ExternalUserParticipantInfo>() {
            public ExternalUserParticipantInfo apply(EventInvitation a) {
                return new ExternalUserParticipantInfo(a);
            }
        };
    }

    @Override
    protected String specifics() {
        return "" + Emails.getUnicoded(email);
    }

    @Override
    public Option<String> getPrivateToken() {
        return invitation.getPrivateToken();
    }

    @Override
    public Option<Instant> getDtstamp() {
        return invitation.getDtstamp();
    }

    @Override
    public int getSequence() {
        return invitation.getSequence();
    }

} //~
