package ru.yandex.calendar.logic.sharing.participant;

import net.fortuna.ical4j.model.parameter.CuType;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

public abstract class ParticipantInfo implements ParticipantBasics {
    ParticipantInfo() {
    }

    public final boolean isResource() {
        return this instanceof ResourceParticipantInfo;
    }

    public final boolean isYandexUser() {
        return this.getKind() == ParticipantKind.YANDEX_USER;
    }

    public abstract ParticipantId getId();
    public abstract long getEventId();
    /** Empty string if unknown */
    public abstract String getHiddenName();
    public abstract Decision getDecision();
    public abstract Option<ActionSource> getDecisionSource();
    public abstract boolean isAttendee();
    public abstract boolean isOptional();
    public abstract boolean isOrganizer();
    public abstract Email getEmail();
    public abstract Option<PassportUid> getUid();
    public abstract String getReason();
    public abstract Option<String> getExchangeId();

    public final String getName() {
        // temp HACK to prevent show-name-by-login for everyone in public calendar
        return isResource() || getUid().isPresent() && getUid().get().isYandexTeamRu() ? getHiddenName() : "";
    }

    public ParticipantData toData() {
        return new ParticipantData(getEmail(), getName(), getDecision(), isAttendee(), isOrganizer(), isOptional());
    }

    public ParticipantKind getKind() {
        return getId().getKind();
    }

    public final CuType getCuType() {
        if (this.isResource()) {
            return CuType.ROOM;
        } else {
            return CuType.INDIVIDUAL;
        }
    }

    public static Function<ParticipantInfo, Long> getEventIdF() {
        return ParticipantInfo::getEventId;
    }

    public static Function<ParticipantInfo, Email> getEmailF() {
        return ParticipantInfo::getEmail;
    }

    public static Function<ParticipantInfo, Option<PassportUid>> getUidF() {
        return ParticipantInfo::getUid;
    }

    public static Function<ParticipantInfo, ParticipantId> getIdF() {
        return ParticipantInfo::getId;
    }

    public static Function1B<ParticipantInfo> isOrganizerF() {
        return ParticipantInfo::isOrganizer;
    }

    public static Function1B<ParticipantInfo> isAttendeeF() {
        return ParticipantInfo::isAttendee;
    }

    public static Function1B<ParticipantInfo> isOptionalF() {
        return ParticipantInfo::isOptional;
    }

    public static Function1B<ParticipantInfo> isResourceF() {
        return ParticipantInfo::isResource;
    }

    public static Function<ParticipantInfo, Decision> getDecisionF() {
        return ParticipantInfo::getDecision;
    }

    public static Function<ParticipantInfo, String> getNameF() {
        return ParticipantInfo::getName;
    }

    public static Function1B<ParticipantInfo> isYandexUserWithSomeOfUidsF(CollectionF<PassportUid> uids) {
        return ParticipantInfo.getIdF().andThen(ParticipantId.getUidIfYandexUserF().andThen(Cf2.isSomeOfF(uids)));
    }

    public Option<SettingsInfo> getSettingsIfYandexUser() {
        return Option.when(this instanceof YandexUserParticipantInfo, () -> ((YandexUserParticipantInfo) this).getSettings());
    }

    public boolean letParticipantsEdit() {
        return getSettingsIfYandexUser().exists(s -> s.getYt().isPresent() && s.getYt().get().getLetParticipantsEdit());
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "[" + specifics() + ",o=" + (isOrganizer() ? "t" : "f") + ",a=" + (isAttendee() ? "t" : "f") + ",...]";
    }

    protected abstract String specifics();

    public static Function<ParticipantInfo, Option<SettingsInfo>> getSettingsIfUserF() {
        return ParticipantInfo::getSettingsIfYandexUser;
    }
}
