package ru.yandex.calendar.logic.sharing.participant;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.sharing.InvAcceptingType;
import ru.yandex.calendar.logic.user.SettingsInfo;

public abstract class UserParticipantInfo extends ParticipantInfo {
    public abstract Option<String> getPrivateToken();
    public abstract Option<Instant> getDtstamp();
    public abstract int getSequence();

    public static Function<UserParticipantInfo, Option<String>> getLoginIfYandexUserF() {
        return UserParticipantInfo::getLoginIfYandexUser;
    }

    public Option<String> getLoginIfYandexUser() {
        return this.isYandexUser() ? ((YandexUserParticipantInfo) this).getLogin() : Option.empty();
    }

    public Option<SettingsInfo> getSettingsIfYandexUser() {
        return this instanceof YandexUserParticipantInfo
                ? Option.of(((YandexUserParticipantInfo) this).getSettings())
                : Option.empty();
    }

    public Option<SettingsYt> getYtSettingsIfYtUser() {
        return getSettingsIfYandexUser().filterMap(SettingsInfo::getYt);
    }

    public boolean isAutoAcceptInvitations() {
        return getSettingsIfYandexUser().exists(SettingsInfo.getCommonF().andThen(
                Settings.getInvAcceptTypeF().andThenEquals(InvAcceptingType.MANUAL).notF()));
    }

    public boolean isSubscriber() {
        if (this.isYandexUser()) {
            EventUser eu = ((YandexUserParticipantInfo) this).getEventUser();
            return !eu.getIsAttendee() && !eu.getIsOrganizer() && eu.getIsSubscriber();
        }
        return false;
    }

    public boolean isOutlookerOrEwser() {
        return this.isYandexUser() && ((YandexUserParticipantInfo) this).getSettings().isOutlookerOrEwser();
    }
} //~
