package ru.yandex.calendar.logic.sharing.participant;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

public class YandexUserParticipantInfo extends UserParticipantInfo {
    private final EventUser eventUser;
    private final SettingsInfo settings;

    // why would settings.getUid(), .getEmail() change, so we store them? // ssytnik@
    private final PassportUid uid;
    private final Email email;

    public YandexUserParticipantInfo(EventUser eventUser, SettingsInfo settings) {
        this.eventUser = eventUser;
        this.settings = settings;

        this.uid = settings.getUid();
        this.email = settings.getEmail();
    }

    @Override
    public ParticipantId getId() {
        return ParticipantId.yandexUid(settings.getUid());
    }

    public SettingsInfo getSettings() {
        return settings;
    }

    public Settings getSettingsCommon() {
        return settings.getCommon();
    }

    public Option<SettingsYt> getSettingsYt() {
        return settings.getYt();
    }

    public EventUser getEventUser() {
        return eventUser;
    }

    @Override
    public long getEventId() {
        return eventUser.getEventId();
    }

    @Override
    public String getHiddenName() {
        return settings.getUserName().getOrElse("");
    }

    @Override
    public Decision getDecision() {
        return eventUser.getDecision();
    }

    @Override
    public Option<ActionSource> getDecisionSource() {
        return eventUser.getDecisionSource();
    }

    @Override
    public boolean isAttendee() {
        return eventUser.getIsAttendee();
    }

    @Override
    public boolean isOptional() {
        return eventUser.getIsOptional().orElse(false);
    }

    @Override
    public boolean isOrganizer() {
        return eventUser.getIsOrganizer();
    }

    @Override
    public Email getEmail() {
        return settings.getEmail();
    }

    @Override
    public Option<PassportUid> getUid() {
        return Option.of(getUidSome());
    }

    public PassportUid getUidSome() {
        return settings.getUid();
    }

    @Override
    public String getReason() {
        return eventUser.getReason().getOrElse("");
    }

    @Override
    public Option<String> getExchangeId() {
        return eventUser.getExchangeId();
    }

    public static Function<YandexUserParticipantInfo, EventUser> eventUserF() {
        return YandexUserParticipantInfo::getEventUser;
    }

    public static Function<YandexUserParticipantInfo, PassportUid> getUidSomeF() {
        return YandexUserParticipantInfo::getUidSome;
    }

    public static Function<YandexUserParticipantInfo, Option<SettingsYt>> getSettingsYtF() {
        return YandexUserParticipantInfo::getSettingsYt;
    }

    public static Function2<EventUser, SettingsInfo, YandexUserParticipantInfo> consF() {
        return YandexUserParticipantInfo::new;
    }

    @Override
    protected String specifics() {
        return uid + "," + Emails.getUnicoded(email);
    }

    @Override
    public Option<String> getPrivateToken() {
        return eventUser.getPrivateToken();
    }

    @Override
    public Option<Instant> getDtstamp() {
        return eventUser.getDtstamp();
    }

    @Override
    public int getSequence() {
        return eventUser.getSequence();
    }

    public Option<String> getLogin() {
        return settings.getUserLogin();
    }

} //~
