package ru.yandex.calendar.logic.sharing.perm;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.event.model.ParticipantsOrInvitationsData;
import ru.yandex.calendar.logic.layer.LayerType;
import ru.yandex.calendar.logic.layer.UserLayersSharing;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.sharing.participant.EventParticipants;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.calendar.micro.perm.EventAction;
import ru.yandex.calendar.micro.perm.LayerAction;
import ru.yandex.inside.passport.PassportUid;

public interface Authorizer {
    void loadBatchAndCacheAllRequiredForPermsCheck(PassportUid uid, List<EventWithRelations> events);

    boolean canPerformLayerAction(LayerInfoForPermsCheck layer, LayerAction action, ActionSource actionSource);
    boolean canPerformLayerAction(UserInfo user, LayerInfoForPermsCheck layer, Optional<UserLayersSharing> sharing, LayerAction action,
                                  ActionSource source);

    void ensureCanPerformLayerAction(LayerInfoForPermsCheck layer, LayerAction action, ActionSource actionSource);
    void ensureCanPerformLayerAction(UserInfo user, LayerInfoForPermsCheck layer, Optional<UserLayersSharing> sharing, LayerAction action,
                                     ActionSource source);

    void ensureLayerType(LayerInfoForPermsCheck layer, LayerType... types);
    void ensureLayerProperties(LayerInfoForPermsCheck layer, PassportUid uid, LayerType... types);
    void ensureCanPerformLayerActionType(UserInfo user, LayerInfoForPermsCheck layer, LayerAction action, ActionSource actionSource, LayerType... types);

    boolean canViewEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    boolean canViewEvent(EventInfoForPermsCheck event, ActionSource actionSource);

    boolean hasSuperSecret(EventWithRelations event);

    boolean canEditEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    boolean canEditEvent(EventInfoForPermsCheck event, ActionSource actionSource);

    boolean canEditEventPermissions(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    boolean canDeleteEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    boolean canDeleteEvent(EventInfoForPermsCheck event, ActionSource actionSource);

    boolean canSplitEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    boolean canSplitEvent(EventInfoForPermsCheck event, ActionSource actionSource);

    boolean canInviteToEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    boolean canChangeOrganizer(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    boolean canAdminAllResources(UserInfo user, List<Resource> resources);

    boolean canViewAnyEventForAllResources(UserInfo user, List<ResourceInfoForPermsCheck> resources);

    boolean canAdminSomeEventResources(UserInfo user, List<ResourceInfoForPermsCheck> resources);

    boolean canViewAllEventResources(UserInfo user, List<ResourceInfoForPermsCheck> resources);

    void ensureCanDeleteEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    void ensureCanDeleteEvent(EventInfoForPermsCheck event, ActionSource actionSource);

    void ensureCanEditEventPermissions(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    void ensureCanEditEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    void ensureCanInviteToEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    void ensureCanSplitEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);

    void ensureCanViewEvent(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    void ensureCanViewEvent(EventInfoForPermsCheck event, ActionSource actionSource);
    void ensureCanViewEvent(UserInfo user, EventInfoForPermsCheck event, boolean tokenPresent, ActionSource actionSource);
    void ensureCanViewEventForParticipant(UserInfo participant, PassportUid actorUid, EventInfoForPermsCheck event, boolean tokenPresent, ActionSource actionSource);

    boolean canViewAvailability(UserInfo user, UidOrResourceId subjectId);

    ParticipantsAvailability canViewAvailability(UserInfo user, List<UidOrResourceId> subjectIds);
    ParticipantsAvailability canViewAvailability(UserInfo user, List<PassportUid> users, List<Resource> resources);

    List<EventInfoForPermsCheck> loadInfoForPermsCheck(UserInfo userInfo, List<EventFieldsForPermsCheck> eventFields, List<EventParticipants> eventParticipants);
    List<EventInfoForPermsCheck> loadInfoForPermsCheck(List<EventFieldsForPermsCheck> eventFields, List<EventParticipants> eventParticipants);

    Map<Long, EventInfoForPermsCheck> loadEventsInfoForPermsCheck(UserInfo user, List<EventWithRelations> events);
    EventInfoForPermsCheck loadEventInfoForPermsCheck(UserInfo user, EventWithRelations event);
    EventInfoForPermsCheck loadEventInfoForPermsCheck(EventWithRelations event);

    EventInfoForPermsCheck loadEventInfoForPermsCheck(UserInfo user, EventWithRelations event, UserLayersSharing userLayersSharing);
    EventInfoForPermsCheck loadEventInfoForPermsCheck(EventWithRelations event, UserLayersSharing userLayersSharing);

    EventInfoForPermsCheck loadInfoForPermsCheckByEvents(Optional<UserInfo> userInfo, Event event);
    List<EventInfoForPermsCheck> loadInfoForPermsCheckByEvents(Optional<UserInfo> userInfo, List<Event> events);
    EventInfoForPermsCheck loadEventInfoForPermsCheck(Optional<UserInfo> userO, EventWithRelations event,
                                                      Optional<Layer> detachedLayer,
                                                      Optional<UserLayersSharing> userLayersSharingO);

    void ensurePermittedOrganizerSetting(UserInfo user, Optional<Event> event, ParticipantsOrInvitationsData invitationsData, ActionSource actionSource);

    List<Long> getNonBookableResourceIds(UserInfo user, List<Resource> resources);

    void ensureMoveAction(UserInfo user, long oldLayerId, long newLayerId, LayerAction oldAction, ActionSource source);

    EnumSet<EventAction> getEventPermissions(UserInfo user, EventInfoForPermsCheck event, ActionSource actionSource);
    EnumSet<EventAction> getEventPermissions(EventInfoForPermsCheck event, ActionSource actionSource);

    UserLayersSharing loadLayerSharing(PassportUid uid);
    Map<PassportUid, UserLayersSharing> loadLayerSharing(Set<PassportUid> uids);
}
