package ru.yandex.calendar.logic.sharing.perm;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * Available values of Event permission fields
 * that denote event atomic permission classes.
 * NOTE: do not cover all atomic event actions.
 * @author ssytnik
 */
public enum EventActionClass implements StringEnum {
    /**
     * Nothing
     */
    NONE,
    /**
     * View full event information
     */
    VIEW,
    /**
     * View and edit event
     */
    EDIT,
    ;

    public static final StringEnumResolver<EventActionClass> R = StringEnumResolver.r(EventActionClass.class);

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    @Override
    public String value() {
        return toDbValue();
    }
}
